<?php

if (!current_user_can(get_option($this->shared->get('slug') . "_import_menu_capability"))) {
    wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'dalt'));
}

?>

<!-- output -->

<div class="wrap">

    <h2><?php esc_html_e('League Table - Import', 'dalt'); ?></h2>

    <div id="daext-menu-wrapper">

        <?php

        //process the xml file upload
        if (isset($_FILES['file_to_upload']) and
            isset($_FILES['file_to_upload']['name']) and
            preg_match('/^.+\.xml$/', $_FILES['file_to_upload']['name'], $matches) === 1
        ) {

            $counter = 0;

            if (file_exists($_FILES['file_to_upload']['tmp_name'])) {

                global $wpdb;

                //read xml file
                $xml = simplexml_load_file($_FILES['file_to_upload']['tmp_name']);

                $table_a = $xml->table;

                foreach ($table_a as $single_table) {

                    //convert object to array
                    $single_table_a = get_object_vars($single_table);

	                //replace empty objects with empty strings to prevent notices on the next insert() method
	                $single_table_a = $this->shared->replace_empty_objects_with_empty_strings($single_table_a);

                    //remove the id key
                    unset($single_table_a['id']);

                    //save the data key for later use and remove the data key from the main array
                    $data_a = get_object_vars($single_table_a['data']);
                    unset($single_table_a['data']);

                    //save the cell key for later use or set its value to null if there are no cell
                    if($single_table_a['cell'] !== ''){
	                    $cell_a = get_object_vars($single_table_a['cell']);
                    }else{
                        $cell_a = null;
                    }

                    //remove the cell key from the main array
                    unset($single_table_a['cell']);

                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
                    $wpdb->insert(
                        $table_name,
                        $single_table_a
                    );
                    $inserted_table_id = $wpdb->insert_id;

                    //add the data -------------------------------------------------------------------------------------
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
                    $record_a = $data_a['record'];

                    if (is_array($record_a)) {

                        /*
                         * If this table has multiple rows $record_a is an array filled with objects of type
                         * [SimpleXMLElement]. Each object is converted to an array and is then passed to the
                         * $wpdb->insert method and inserted in the database
                         */
                        foreach ($record_a as $single_record) {

                            $single_record_a = get_object_vars($single_record);

	                        //replace empty objects with empty strings to prevent notices on the next insert() method
	                        $single_record_a = $this->shared->replace_empty_objects_with_empty_strings($single_record_a);

                            //remove the id key
                            unset($single_record_a['id']);

                            //set the table_id based on the id inserted during the creation of the table
                            $single_record_a['table_id'] = $inserted_table_id;

                            $wpdb->insert(
                                $table_name,
                                $single_record_a
                            );

                        }

                    } else {

                        /*
                         * If this table has a single row $record_a is an object of type [SimpleXMLElement] and is
                         * converted to an array and passed to the $wpdb->insert method and inserted in the database
                         */
                        $single_record_a = get_object_vars($record_a);

	                    //replace empty objects with empty strings to prevent notices on the next insert() method
	                    $single_record_a = $this->shared->replace_empty_objects_with_empty_strings($single_record_a);

                        //remove the id key
                        unset($single_record_a['id']);

                        //set the table_id based on the id inserted during the creation of the table
                        $single_record_a['table_id'] = $inserted_table_id;

                        $wpdb->insert(
                            $table_name,
                            $single_record_a
                        );

                    }

                    //add the cell -------------------------------------------------------------------------------------
                    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";

                    //add the cell only if there are the proper data
                    if($cell_a !== null and isset($cell_a['record'])){

                        $record_a = $cell_a['record'];

                        if (is_array($record_a)) {

                            /*
                             * If this table has multiple rows $record_a is an array filled with objects of type
                             * [SimpleXMLElement]. Each object is converted to an array and is then passed to the
                             * $wpdb->insert method and inserted in the database
                             */
                            foreach ($record_a as $single_record) {

                                $single_record_a = get_object_vars($single_record);

	                            //replace empty objects with empty strings to prevent notices on the next insert() method
	                            $single_record_a = $this->shared->replace_empty_objects_with_empty_strings($single_record_a);

                                //remove the id key
                                unset($single_record_a['id']);

                                //set the table_id based on the id inserted during the creation of the table
                                $single_record_a['table_id'] = $inserted_table_id;

                                $wpdb->insert(
                                    $table_name,
                                    $single_record_a
                                );

                            }

                        } else {

                            /*
                             * If this table has a single row $record_a is an object of type [SimpleXMLElement] and is
                             * converted to an array and passed to the $wpdb->insert method and inserted in the database
                             */
                            $single_record_a = get_object_vars($record_a);

	                        //replace empty objects with empty strings to prevent notices on the next insert() method
	                        $single_record_a = $this->shared->replace_empty_objects_with_empty_strings($single_record_a);

                            //remove the id key
                            unset($single_record_a['id']);

                            //set the table_id based on the id inserted during the creation of the table
                            $single_record_a['table_id'] = $inserted_table_id;

                            $wpdb->insert(
                                $table_name,
                                $single_record_a
                            );

                        }

                    }

                    $counter++;

                }

                echo '<div class="updated settings-error notice is-dismissible below-h2"><p>' . $counter . ' ' . esc_html__('tables have been added.', 'dalt') . '</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">' . esc_html__('Dismiss this notice.', 'dalt') . '</span></button></div>';

            }

        }

        ?>

        <p><?php esc_html_e('Import the tables stored in your XML file by clicking the Upload file and import button.', 'dalt'); ?></p>
        <form enctype="multipart/form-data" id="import-upload-form" method="post" class="wp-upload-form" action="">
            <p>
                <label for="upload"><?php esc_html_e('Choose a file from your computer:', 'dalt'); ?></label>
                <input type="file" id="upload" name="file_to_upload">
            </p>
            <p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary"
                                     value="<?php esc_attr_e('Upload file and import', 'dalt'); ?>"></p>
        </form>
        <p><strong><?php esc_html_e('IMPORTANT: This menu should only be used to import the XML files generated with the "Export" menu.', 'dalt'); ?></strong></p>

    </div>

</div>